divert(-1)

###############################################################
# MEMORY BANKING USER CONFIGURATION
# rebuild the library if changes are made
#

## 16k Memory Banking (128k Spectrum)

# PORT 0x7FFD: 128k Memory Mapping 1

define(`__IO_7FFD', 0x7ffd)
define(`__IO_7FFD_LOCK', 0x20)           # lock 16k banking via 0x1ffd, 0x7ffd, 0xdffd
define(`__IO_7FFD_ROM0', 0x10)
define(`__IO_7FFD_ALT_DFILE', 0x08)
define(`__IO_7FFD_RAM_PAGE_MASK', 0x07)  # bottom three bits of 16k bank number

# PORT 0xDFFD: 16k Bank Number

define(`__IO_DFFD', 0xdffd)              # top four bits of 16k bank number
define(`__IO_DFFD_RAM_PAGE_MASK', 0x0f)

# PORT 0x1FFD: 128k Memory Mapping 2

define(`__IO_1FFD', 0x1ffd)
define(`__IO_1FFD_PAGING_MODE_NORMAL', 0x00)
define(`__IO_1FFD_PAGING_MODE_SPECIAL', 0x01)
define(`__IO_1FFD_PAGING_MODE_SPECIAL_3210', 0x01)
define(`__IO_1FFD_PAGING_MODE_SPECIAL_7654', 0x03)
define(`__IO_1FFD_PAGING_MODE_SPECIAL_3654', 0x05)
define(`__IO_1FFD_PAGING_MODE_SPECIAL_3674', 0x07)
define(`__IO_1FFD_ROM1', 0x04)
define(`__IO_1FFD_DISK_MOTOR', 0x08)
define(`__IO_1FFD_PRINTER_STROBE', 0x10)

# NEXTREG 8: Peripheral 3
#
# define(`__REG_PERIPHERAL_3', 8)
# define(`__RP3_STEREO_ABC', 0x00)
# define(`__RP3_STEREO_ACB', 0x20)
# define(`__RP3_ENABLE_SPEAKER', 0x10)
# define(`__RP3_ENABLE_SPECDRUM', 0x08)
# define(`__RP3_ENABLE_COVOX', 0x08)
# define(`__RP3_ENABLE_TIMEX', 0x04)
# define(`__RP3_ENABLE_TURBOSOUND', 0x02)
# define(`__RP3_UNLOCK_7FFD', 0x80)       # unlock port 0x7ffd (resets the lock bit)

## 8k Memory Banking (Spectrum Next)

# NEXTREG 80-87
#
# define(`__REG_MMU0', 80)
# define(`__REG_MMU1', 81)
# define(`__REG_MMU2', 82)
# define(`__REG_MMU3', 83)
# define(`__REG_MMU4', 84)
# define(`__REG_MMU5', 85)
# define(`__REG_MMU6', 86)
# define(`__REG_MMU7', 87)

#
# END OF USER CONFIGURATION
###############################################################

divert(0)

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_PUB',
`
PUBLIC `__IO_7FFD'
PUBLIC `__IO_7FFD_LOCK'
PUBLIC `__IO_7FFD_ROM0'
PUBLIC `__IO_7FFD_ALT_DFILE'
PUBLIC `__IO_7FFD_RAM_PAGE_MASK'

PUBLIC `__IO_DFFD'
PUBLIC `__IO_DFFD_RAM_PAGE_MASK'

PUBLIC `__IO_1FFD'
PUBLIC `__IO_1FFD_PAGING_MODE_NORMAL'
PUBLIC `__IO_1FFD_PAGING_MODE_SPECIAL'
PUBLIC `__IO_1FFD_PAGING_MODE_SPECIAL_3210'
PUBLIC `__IO_1FFD_PAGING_MODE_SPECIAL_7654'
PUBLIC `__IO_1FFD_PAGING_MODE_SPECIAL_3654'
PUBLIC `__IO_1FFD_PAGING_MODE_SPECIAL_3674'
PUBLIC `__IO_1FFD_ROM1'
PUBLIC `__IO_1FFD_DISK_MOTOR'
PUBLIC `__IO_1FFD_PRINTER_STROBE'
')

dnl#
dnl# LIBRARY BUILD TIME CONFIG FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_DEF',
`
defc `__IO_7FFD' = __IO_7FFD
defc `__IO_7FFD_LOCK' = __IO_7FFD_LOCK
defc `__IO_7FFD_ROM0' = __IO_7FFD_ROM0
defc `__IO_7FFD_ALT_DFILE' = __IO_7FFD_ALT_DFILE
defc `__IO_7FFD_RAM_PAGE_MASK' = __IO_7FFD_RAM_PAGE_MASK

defc `__IO_DFFD' = __IO_DFFD
defc `__IO_DFFD_RAM_PAGE_MASK' = __IO_DFFD_RAM_PAGE_MASK

defc `__IO_1FFD' = __IO_1FFD
defc `__IO_1FFD_PAGING_MODE_NORMAL' = __IO_1FFD_PAGING_MODE_NORMAL
defc `__IO_1FFD_PAGING_MODE_SPECIAL' = __IO_1FFD_PAGING_MODE_SPECIAL
defc `__IO_1FFD_PAGING_MODE_SPECIAL_3210' = __IO_1FFD_PAGING_MODE_SPECIAL_3210
defc `__IO_1FFD_PAGING_MODE_SPECIAL_7654' = __IO_1FFD_PAGING_MODE_SPECIAL_7654
defc `__IO_1FFD_PAGING_MODE_SPECIAL_3654' = __IO_1FFD_PAGING_MODE_SPECIAL_3654
defc `__IO_1FFD_PAGING_MODE_SPECIAL_3674' = __IO_1FFD_PAGING_MODE_SPECIAL_3674
defc `__IO_1FFD_ROM1' = __IO_1FFD_ROM1
defc `__IO_1FFD_DISK_MOTOR' = __IO_1FFD_DISK_MOTOR
defc `__IO_1FFD_PRINTER_STROBE' = __IO_1FFD_PRINTER_STROBE
')

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR C
dnl#

ifdef(`CFG_C_DEF',
`
`#define' `__IO_7FFD'  __IO_7FFD
`#define' `__IO_7FFD_LOCK'  __IO_7FFD_LOCK
`#define' `__IO_7FFD_ROM0'  __IO_7FFD_ROM0
`#define' `__IO_7FFD_ALT_DFILE'  __IO_7FFD_ALT_DFILE
`#define' `__IO_7FFD_RAM_PAGE_MASK'  __IO_7FFD_RAM_PAGE_MASK

`#define' `__IO_DFFD'  __IO_DFFD
`#define' `__IO_DFFD_RAM_PAGE_MASK'  __IO_DFFD_RAM_PAGE_MASK

`#define' `__IO_1FFD'  __IO_1FFD
`#define' `__IO_1FFD_PAGING_MODE_NORMAL'  __IO_1FFD_PAGING_MODE_NORMAL
`#define' `__IO_1FFD_PAGING_MODE_SPECIAL'  __IO_1FFD_PAGING_MODE_SPECIAL
`#define' `__IO_1FFD_PAGING_MODE_SPECIAL_3210'  __IO_1FFD_PAGING_MODE_SPECIAL_3210
`#define' `__IO_1FFD_PAGING_MODE_SPECIAL_7654'  __IO_1FFD_PAGING_MODE_SPECIAL_7654
`#define' `__IO_1FFD_PAGING_MODE_SPECIAL_3654'  __IO_1FFD_PAGING_MODE_SPECIAL_3654
`#define' `__IO_1FFD_PAGING_MODE_SPECIAL_3674'  __IO_1FFD_PAGING_MODE_SPECIAL_3674
`#define' `__IO_1FFD_ROM1'  __IO_1FFD_ROM1
`#define' `__IO_1FFD_DISK_MOTOR'  __IO_1FFD_DISK_MOTOR
`#define' `__IO_1FFD_PRINTER_STROBE'  __IO_1FFD_PRINTER_STROBE
')
